require 'page-object'
require 'enumerator'

class LandingPage
  include PageObject
  def initialize(driver)
    @driver = driver
    super(driver)
  end

  #View Settings button
  button(:view_settings,:css => "#open-settings-btn")
  button(:login_button,:css => "#login")
  button(:logout_button,:css=> "#logout")
  button(:changeLocationViewSettings, :css =>'#about-ok-btn')
  button(:changeLocationCancelButton, :css=>'.modal-dialog .modal-footer button:nth-child(2)')

  #Manage/View Settings Panel
  button(:change_location,:css => "#change-location-btn")
  unordered_list(:options_list,:css => "body > div.container-fluid.ng-scope > div.main-content.ng-scope.snap-content > div.full-height.ng-scope > div.col-xs-12.column.secondary-content.ng-scope.col-sm-3 > div:nth-child(2) > div > ul")
  div(:detail_panel_text,:css => "body > div.container-fluid.ng-scope > div.main-content.ng-scope.snap-content > div.full-height.ng-scope > div.col-xs-12.column.primary-content.ng-scope.col-sm-9")
  select(:facility_location, :name => 'institutionsChoiceForm')
  span(:request_button,:css => "body > div.container-fluid.ng-scope > div.main-content.ng-scope.snap-content > div.full-height.ng-scope > div.col-xs-12.column.secondary-content.ng-scope.col-sm-3 > div:nth-child(2) > div > ul > li:nth-child(2) > button > span > div > div > span")


  select_list(:change_location_list, :id => 'institution-select')
  h4(:home_facility, :id =>'home-facility')
  select_list(:facility_location, :id => 'institutionsChoiceForm-select')
  div(:error_message_displayed, :css=>".validation-summary")


  def getLocalDate
    d = Date.today.to_s(:long)
    return d
  end

  def viewFacilitySettings(facilityValue)
    facility_location_element.wait_until_present(TIME_OUT_LIMIT)
    facility_location_element.select_value(facilityValue)
    view_settings_element.wait_until_present(TIME_OUT_LIMIT)
    view_settings
  end


  def changeFacility(facilityValue)
    facility_location_element.wait_until_present(TIME_OUT_LIMIT)
    facility_location_element.select_value(facilityValue)
    changeLocationViewSettings_element.wait_until_present(TIME_OUT_LIMIT)
    changeLocationViewSettings
  end

  def changeLocation(facilityValue)
    change_location_list_element.wait_until_present(TIME_OUT_LIMIT)
    change_location_list_element.select(facilityValue)
    changeLocationViewSettings_element.wait_until_present(TIME_OUT_LIMIT)
    #changeLocationViewSettings
  end

  def cancelChangeFacility(facilityValue)
    change_location_list_element.wait_until_present(TIME_OUT_LIMIT)
    change_location_list_element.select_value(facilityValue)
    changeLocationViewSettings_element.wait_until_present(TIME_OUT_LIMIT)
    changeLocationCancelButton
  end

  def isFacilityListSorted?
    sorted = false
    listOptions = facility_location_element.options.map(&:text)
    puts "lst is", listOptions.drop(1)
    if listOptions.drop(1).each_cons(2).all? {|a,b| (a<=b)}
      sorted = true
    end
    return sorted
  end

  def pleaseSelectViewSettingsDisplayed?
    errorMessage = false

  end

end
